import cv2
import numpy as np
from dataInput_creatMask import create_mask
import tensorflow as tf
import numpy as np
from keras.models import load_model

def print_hsv_values_with_image(filename):
    height = 128
    width = 128
    # 將圖片轉換為HSV色彩空間
    input_data = tf.keras.utils.load_img( filename, target_size=(128, 128), color_mode="rgb")
    input_data = tf.keras.utils.img_to_array(input_data)/255.0
    hsv_image = cv2.cvtColor((input_data * 255).astype(np.uint8), cv2.COLOR_BGR2HSV)
    dataset = tf.data.Dataset.from_tensor_slices([input_data])
    dataset_batched = dataset.batch(1)
    try:
        model = load_model('./model/model_0501.h5', compile=False)
    except:
        return "Not find model"
    try:
        dataset_pred = model.predict(dataset_batched)  # Use model to predict
        dataset_pred = create_mask(dataset_pred)
    except:
        return "Not find model"
    if dataset_pred.shape[-1] == 1:
        dataset_pred = np.squeeze(dataset_pred, axis=-1)
    dataset_pred = (dataset_pred * 255).astype(np.uint8)
    # 顯示HSV值
    hsv_image_display = np.zeros((height, width, 3), dtype=np.uint8)
    hsv_s_image_display = np.zeros((height, width, 1), dtype=np.uint8)
    hsv_v_image_display = np.zeros((height, width, 1), dtype=np.uint8)
    c = 0 #　available pixel
    for y in range(height):
        for x in range(width):
            h, s, v = hsv_image[y, x]
            if([h, s, v] != [0, 0, 0] and (s > 35 and v < 215)):
                c +=1
                hsv_image_display[y, x] = h
                hsv_s_image_display[y, x] = s
                hsv_v_image_display[y, x] = v
    # 顯示原始圖片和HSV值圖像
    print("available pixel: ", c)
    cv2.imshow("Original Image", dataset_pred)
    cv2.imshow("HSV Image", hsv_image_display)
    cv2.imshow("HSV_s Image", hsv_s_image_display)
    cv2.imshow("HSV_v Image", hsv_v_image_display)
    cv2.waitKey(0)
    cv2.destroyAllWindows()

# 讀取輸入圖片
input_image = './test.png'

# 呼叫函式來印出每個像素的HSV值並顯示圖像
print_hsv_values_with_image(input_image)