import tensorflow as tf
import numpy as np
from keras.models import load_model
import os
import cv2

os.environ["KMP_DUPLICATE_LIB_OK"] = "TRUE"
def create_mask(pred_mask):
    pred_mask = tf.math.argmax(pred_mask, axis=-1)
    pred_mask = pred_mask[..., tf.newaxis]
    return pred_mask[0]
def dataInput_creatMask_rgb(folder_name , model_where):
    analyze_data = {"R_avg":[{'file_name': " " , 'data': 0 }] , 
                    "G_B_avg":[{'file_name': " " , 'data': 0 }],
                    "r_minus_gb_avg_withoutmax":[{'file_name': " " , 'data': 0 }]}
    try:
        for filename in os.listdir(folder_name):
            input_data = tf.keras.utils.load_img( folder_name + filename, target_size=(128, 128), color_mode="rgb")
            input_data = tf.keras.utils.img_to_array(input_data)/255.0
            hsv_image = cv2.cvtColor((input_data * 255).astype(np.uint8), cv2.COLOR_BGR2HSV)
            dataset = tf.data.Dataset.from_tensor_slices([input_data])
            dataset_batched = dataset.batch(1)
            try:
                model = load_model(model_where, compile=False)
            except:
                return "Not find model"
            try:
                dataset_pred = model.predict(dataset_batched)  # Use model to predict
                dataset_pred = create_mask(dataset_pred)
            except:
                continue
            if dataset_pred.shape[-1] == 1:
                dataset_pred = np.squeeze(dataset_pred, axis=-1)
            # Scale the image to 0-255
            dataset_pred = (dataset_pred * 255).astype(np.uint8)
            input_data_color = np.zeros((3, ))
            len = 0
            input_data_color_r_minus_gb = []
            for i in range(128):
                for j in range(128):
                    if dataset_pred[i][j] != 0 :
                        h, s, v = hsv_image[i, j]
                        if (s > 35 and v < 215):
                            # 平均
                            input_data_color +=  input_data[i][j]
                            len +=1
                            input_data_color_r_minus_gb.append(input_data[i][j][0] - (input_data[i][j][1]+input_data[i][j][2])/2)
            q1 = np.percentile(input_data_color_r_minus_gb,25)
            q3 = np.percentile(input_data_color_r_minus_gb,75)
            iqr = q3 - q1
            lower_fence = q1 - 1 * iqr 
            upper_fence = q3 + 1 * iqr
            output_color_r_minus_gb_value = 0
            output_color_r_minus_gb_len = 0
            for x in input_data_color_r_minus_gb: 
                if x > lower_fence and x < upper_fence: 
                    output_color_r_minus_gb_value += x
                    output_color_r_minus_gb_len += 1
            output_color_r_minus_gb_avg = output_color_r_minus_gb_value/output_color_r_minus_gb_len
            analyze_data["R_avg"].append({'file_name' : filename
                                        ,'data': input_data_color[0]/len})
            analyze_data["G_B_avg"].append( {'file_name' : filename
                                        ,'data' : (input_data_color[1]/len + input_data_color[2]/len)/2})
            analyze_data["r_minus_gb_avg_withoutmax"].append( {'file_name' : filename
                                        ,'data' : output_color_r_minus_gb_avg})
        return  analyze_data
    except:
        return "None file in this folder"