#pragma once
#define _CRT_SECURE_NO_DEPRECATE

#include "ArduinoAdaptor.h"
#include "NSP32.h"
#include <SPI.h>
#include "FS.h"
#include <TFT_eSPI.h> // Hardware-specific library
#include <ESP32Time.h>
#include <Wire.h>
#include "SD.h"

#include "EloquentTinyML.h" 
#include "eloquent_tinyml/tensorflow.h" 
#include "model.h" 

void PinReadyTriggerISR();
void drawKeypad();
void touch_calibrate();
int8_t TCA_writeBytes(uint8_t devAddr, uint8_t regAddr, uint8_t length, uint8_t *data);
int8_t TCA_writeByte(uint8_t devAddr, uint8_t regAddr, uint8_t data);
int8_t TCA_read(uint8_t devAddr, uint8_t regAddr, uint8_t length, uint8_t *data, uint16_t timeout);
bool TCA_isConnected();
void listDir(fs::FS &fs, const char * dirname, uint8_t levels);
void createDir(fs::FS &fs, const char * path);
void removeDir(fs::FS &fs, const char * path);
void readFile(fs::FS &fs, String path);
void writeFile(fs::FS &fs, String path, float message[] , int messageSize);

